     Fs = 8192;                   % Sample frequency
      t = 0:1/Fs:3;                % Time axis
      x = real(sqrt(1-(t-1.5).^2));  % Half circle in time/x space
      y = t*0;
      ind= find((t>.5)&(t<2.5));

      y(ind) = vco(x(ind),[1000 4000],Fs) + vco(-x(ind),[1000 4000],Fs);

      y(ind(1:200))= y(ind(1:200)).*((1:200)/200); % Trapazoidal window
      n = length(ind);                             % to reduce transient
      y(ind(n-200:n)) = y(ind(n-200:n)).*(201-(1:201))/200;
	
 % VCO is a new feature of the signal processing toolbox, it simulates
 % a voltage controlled oscillator. It generates a sinusoid whose
 % instantaneous frequency varies as a function of the input signal. 

      x = -real(sqrt(1-((t-1.5)*2).^2))/2; % Another half circle
      ind= find((t>1)&(t<2));

      y2 = vco(x(ind),[1000 3500],Fs);

      y2(1:200) = y2(1:200).*(1:200)/200;
      n = length(y2);
      y2(n-200:n) = y2(n-200:n).*(201-(1:201))/200;
      y(ind) = y(ind) + y2;

      y = y + exp(-(t-1.25).^2*100).*cos(2*pi*t*3000);  %
      y = y + exp(-(t-1.75).^2*100).*cos(2*pi*t*3000);
      y = y + exp(-(t-1.5).^2*800).*cos(2*pi*t*2500)+randn(size(t))*.0001;

      specgram(y);

 % SPECGRAM has also been upgraded in the new release. It now
 % produces a log plot of intensity which allows you to see much
 % more detail than before. New parameters were added
 % including window function and sampling frequency. To get
 % a better looking specgram.. let's set the window length
 % and the sample overlapping.

      specgram(y,1024,Fs,512,370); 

    pause
    soundsc(y) 

